/*
 * Diese Datei ist Teil des GDialog Projektes:
 * "Gigaset-Erweiterung fr ProjectX"
 * 
 * Das GDialog Projekt ist freigegeben unter
 * der GNU Public Licence (GPL), deren Text sich in
 * dem Quellen-Verzeichnis befindet. Ist er dort nicht
 * mehr vorhanden, so kann er unter http://www.gnu.org/licenses/gpl.html
 * eingesehen werden.
 */
package de.m740.projectx.gigaset;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

import net.sourceforge.dvb.projectx.xinput.XInputDirectory;
import net.sourceforge.dvb.projectx.xinput.XInputFile;
import net.sourceforge.dvb.projectx.xinput.ftp.FtpVO;

/**
 * 30.01.2005
 * 
 * @author Hans
 */
public class GAufnahmeFTP extends GAufnahmeAbstract {

    private XInputFile aCridFile = null;

    private XInputDirectory aCridDirectory = null;

    private List aMpgFiles = null;

    GAufnahmeFTP(XInputFile inpCridFile, XInputDirectory inpCridDirectory) {
        setCridDirectory(inpCridDirectory);
        setCridFile(inpCridFile);
        cridFilename = inpCridFile.getName();
        try {
            readAufnahme();
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        anzahlByte = -1; // unknown
    }

    /**
     * 
     * @param inpCridFile
     * @return String
     */
    private String readSender(XInputFile inpCridFile) {
        String tmpName = getSender();
        try {
            int len = inpCridFile.randomAccessRead(new byte[14]); // skip xx bytes
            if (len < 0) { // EOF
                return tmpName;
            }
            len = readUShort(inpCridFile);
            if (len > 0) {
                if (len > 25) {
                    len = 25;
                }
                byte[] tmpBs = new byte[len];
                len = inpCridFile.randomAccessRead(tmpBs, 0, tmpBs.length);
                if (len >= 0) {
                    tmpName = new String(tmpBs);
                    tmpName = tmpName.trim();
                }
            }
        } catch (Exception e) {
            String tmpString = e.toString();
            GConsole.setInfo(tmpString);
        }
        return tmpName;
    }
    
    /**
     * 
     */
    public void readAufnahme() {
        try {
            XInputFile tmpCridFile = getCridFile();
            GConsole.setInfo(tmpCridFile.toString());
            setAnzahlFMPGsErwartet(-1);
            setAnzahlFMPGsVorhanden(-1);
            setAnzahlMPGsErwartet(-1);
            setAnzahlMPGsVorhanden(-1);
            anzahlByte = -1;
            aMpgFiles = null;
            //
            byte b[];
            tmpCridFile.randomAccessOpen("r");
            tmpCridFile.randomAccessSeek(0);
            tmpCridFile.randomAccessRead(new byte[12]); // skip 12

            // Status: vor, whrend oder nach der Aufnahme
            status = readUInt(tmpCridFile);
            // Startzeit der Sendung in Sekunden
            startZeitInSek = readUInt(tmpCridFile);
            // Endzeit der Sendung in Sekunden (seit dem 1.1.1970)
            endeZeitInSek = readUInt(tmpCridFile);
            tmpCridFile.randomAccessRead(new byte[16]); // skip xx bytes

            // unique Serien-ID
            aSerienID = readUInt(tmpCridFile);
            // gesperrt zum Lschen ? (0: nein, 1: ja)
            gesperrt = readUShort(tmpCridFile);

            b = new byte[readUInt(tmpCridFile)];
            tmpCridFile.randomAccessRead(b, 0, b.length);
            titel = new String(b); // Titel der Sendung
            titel = new DvbString(titel).getDisplayString();

            int z = readUInt(tmpCridFile);
            dateiNamenBasen = new String[z];
            setAnzahlFMPGsErwartet(z);
            for (int i = 0; i < z; i++) {
                b = new byte[readUInt(tmpCridFile)];
                tmpCridFile.randomAccessRead(b, 0, b.length);
                // Dateinamen-Basis d.zugeh.mpg-Dateien
                dateiNamenBasen[i] = new String(b);
                // Aufnahmebeginn in Sekunden (seit dem 1.1.1970)
                aufnahmeBeginnInSek = readUInt(tmpCridFile);
                tmpCridFile.randomAccessRead(new byte[16]); // skip(16);
            } // for i

            // Genre/Herkunft/Zeit, z.B. "Spielfilm USA 2000"
            b = new byte[readUInt(tmpCridFile)];
            tmpCridFile.randomAccessRead(b, 0, b.length);
            info = new String(b);
            info = new DvbString(info).getDisplayString();

            // Inhalt der Sendung
            b = new byte[readUInt(tmpCridFile)];
            tmpCridFile.randomAccessRead(b, 0, b.length);
            inhalt = new String(b);
            inhalt = new DvbString(inhalt).getDisplayString();

            // Soviele Sekunden der Sendung wurden bereits gesehen
            gesehenBisInSek = readUInt(tmpCridFile);
            //
            // since FW 2.3.15 only
            setSender(readSender(tmpCridFile));
            //
            setValid(true);
            tmpCridFile.randomAccessClose();
        } catch (IOException e) {
            GConsole.setErrorMessage(e);
        }
        anzahlByte = -1; // unknown
    }

    private int readUInt(XInputFile inpXFile) throws IOException {
        int ch1 = 0xFF & inpXFile.randomAccessRead();
        int ch2 = 0xFF & inpXFile.randomAccessRead();
        int ch3 = 0xFF & inpXFile.randomAccessRead();
        int ch4 = 0xFF & inpXFile.randomAccessRead();
        return ((ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4);
    }

    private short readUShort(XInputFile inpXFile) throws IOException {
        int ch1 = 0xFF & inpXFile.randomAccessRead();
        int ch2 = 0xFF & inpXFile.randomAccessRead();
        return (short) ((ch1 << 8) + ch2);
    }

    /**
     * @return xInputDirectory
     */
    protected XInputDirectory getCridDirectory() {
        return aCridDirectory;
    }

    /**
     * @param inpInputDirectory
     *            Festzulegender xInputDirectory
     */
    protected void setCridDirectory(XInputDirectory inpInputDirectory) {
        aCridDirectory = inpInputDirectory;
    }

    /**
     * 
     * @param inpDateinamenbasis
     * @return InputDirectory
     */
    private XInputDirectory makeRecDirectory(String inpDateinamenbasis) {
        try {
            XInputDirectory tmpXDirectory = getCridDirectory();
            String tmpAufnahmeverzeichnis = tmpXDirectory.getDirectory();
            String tmpServer = tmpXDirectory.getServer();
            String tmpUser = tmpXDirectory.getUser();
            String tmpPassword = tmpXDirectory.getPassword();
            String tmpDirectory = tmpAufnahmeverzeichnis;
            if (!tmpDirectory.endsWith("/")) {
                tmpDirectory += "/";
            }
            tmpDirectory += ".rec/";
            tmpDirectory += inpDateinamenbasis;
            String tmpPort = tmpXDirectory.getPort();
            FtpVO tmpVO = new FtpVO(tmpServer, tmpUser, tmpPassword,
                    tmpDirectory, tmpPort, null);
            XInputDirectory tmpIDirectory = new XInputDirectory(tmpVO);
            if (tmpIDirectory.test()) {
                return tmpIDirectory;
            }
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return null;
    }

    /**
     * 
     * @param inpFile
     * @return List of Strings (filenames without path)
     */
    private List readFmpgDatei(XInputFile inpFile) {
        List tmpList = null;
        try {
            GConsole.setInfo(inpFile.toString());
            long tmpSize = inpFile.length();
            long anz = tmpSize / 256;
            inpFile.randomAccessOpen("r");
            inpFile.randomAccessSeek(0);
            for (int i = 0; i < anz; i++) {
                inpFile.randomAccessRead(new byte[16]); // skip 16
                byte[] tmpBs = new byte[112];
                inpFile.randomAccessRead(tmpBs);
                String tmpFN = null;
                // terminierende Null suchen
                for (int x = 0; x < tmpBs.length; x++) {
                    if (tmpBs[x] == 0) {
                        String tmpStr = new String(tmpBs, 0, x);
                        String[] tmpStrs = tmpStr.split("/");
                        int len = (tmpStrs == null) ? 0 : tmpStrs.length;
                        if (len > 0) {
                            tmpFN = tmpStrs[len - 1];
                        } else {
                            tmpFN = tmpStr;
                        }
                        break;
                    }
                } // for x
                if (tmpFN != null) {
                    if (tmpList == null) {
                        tmpList = new ArrayList();
                    }
                    tmpList.add(tmpFN);
                }
                inpFile.randomAccessRead(new byte[128]); // skip 128
            } // for i
            inpFile.randomAccessClose();
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpList;
    }

    /**
     * 
     * @param inpXDirectory
     * @param inpDateinamenbasis
     * @return List of XInputFile
     */
    private XInputFile getFMpgFile(XInputDirectory inpXDirectory,
            String inpDateinamenbasis) {
        XInputFile tmpFileFmpg = null;
        try {
            // search fmpg-file
            XInputFile[] tmpFiles = inpXDirectory.getFiles();
            int anzf = (tmpFiles == null) ? 0 : tmpFiles.length;
            for (int i = 0; i < anzf; i++) {
                XInputFile tmpFile = tmpFiles[i];
                String tmpFN = tmpFile.getName();
                if (tmpFN.equals(inpDateinamenbasis)) {
                    tmpFileFmpg = tmpFile;
                    break;
                }
            } // for i
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpFileFmpg;
    }

    /**
     * 
     * @param inpXDirectory
     * @param inpDateinamenbasis
     * @return List of XInputFile
     */
    private List getMpgFiles(XInputDirectory inpXDirectory,
            String inpDateinamenbasis) {
        List tmpList = null;
        try {
//            if (inpXDirectory == null) {
//                return null;
//            }
            // search fmpg-file
            XInputFile[] tmpFiles = inpXDirectory.getFiles();
            int anzf = (tmpFiles == null) ? 0 : tmpFiles.length;
            XInputFile tmpFileFmpg = null;
            for (int i = 0; i < anzf; i++) {
                XInputFile tmpFile = tmpFiles[i];
                String tmpFN = tmpFile.getName();
                if (tmpFN.equals(inpDateinamenbasis)) {
                    tmpFileFmpg = tmpFile;
                    break;
                }
            } // for i
            if (tmpFileFmpg != null) {
                aAnzahlFMPGsVorhanden++;
                // this is the list of mpg's from one fmpg
                List tmpList2 = readFmpgDatei(tmpFileFmpg);
                aAnzahlMPGsErwartet += (tmpList2 == null) ? 0 : tmpList2.size();
                // extract the matching mpg's from current dir
                for (int i = 0; i < anzf; i++) {
                    XInputFile tmpFile = tmpFiles[i];
                    String tmpFN = tmpFile.getName();
                    if (tmpList2 != null && tmpList2.contains(tmpFN)) {
                        if (tmpList == null) {
                            tmpList = new ArrayList();
                        }
                        tmpList.add(tmpFile);
                        aAnzahlMPGsVorhanden++;
                        anzahlByte += tmpFile.length();
                    }
                } // for i
            }
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpList;
    }

    /**
     * 
     * @param inpDateinamenbasis
     * @return List of XInputFile
     */
    private List getMpgFiles(String inpDateinamenbasis) {
        List tmpList = null;
        try {
            XInputDirectory tmpXDirectory = getCridDirectory();
            tmpList = getMpgFiles(tmpXDirectory, inpDateinamenbasis);
            if (tmpList == null || tmpList.size() == 0) {
                tmpXDirectory = makeRecDirectory(inpDateinamenbasis);
                tmpList = getMpgFiles(tmpXDirectory, inpDateinamenbasis);
            }
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpList;
    }

    /**
     * @return List of XInputFile
     */
    private List readMpgFiles() {
        List tmpList = null;
        try {
            anzahlByte = 0;
            setAnzahlFMPGsVorhanden(0);
            setAnzahlMPGsErwartet(0);
            setAnzahlMPGsVorhanden(0);
            int anzf = (dateiNamenBasen == null) ? 0 : dateiNamenBasen.length;
            for (int i = 0; i < anzf; i++) {
                String tmpDateinamenbasis = dateiNamenBasen[i];
                List tmpList2 = getMpgFiles(tmpDateinamenbasis);
                if (tmpList2 != null && tmpList2.size() > 0) {
                    if (tmpList == null) {
                        tmpList = tmpList2;
                    } else {
                        tmpList.addAll(tmpList2);
                    }
                }
            } // for i
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpList;
    }

    /**
     * @return List of XInputFile
     */
    public List getMpgFiles() {
        synchronized (this) {
            try {
                if (aAnzahlMPGsVorhanden < 0) {
                    aMpgFiles = readMpgFiles();
                    fireStateChanged();
                }
            } catch (Exception e) {
                GConsole.setErrorMessage(e);
            }
            return aMpgFiles;
        }        
    }

    /**
     * 
     * @param inpDateinamenbasis
     * @param inpRecOnly true = search the .rec-dirs only
     * @return XInputDirectory if success
     */
    private XInputDirectory getFmpgDirectory(String inpDateinamenbasis, boolean inpRecOnly) {
        try {
            XInputDirectory tmpXDirectory = getCridDirectory();
            XInputFile tmpFile = null;
            if (!inpRecOnly) {
                getFMpgFile(tmpXDirectory, inpDateinamenbasis);
            }
            if (tmpFile == null) {
                tmpXDirectory = makeRecDirectory(inpDateinamenbasis);
                tmpFile = getFMpgFile(tmpXDirectory, inpDateinamenbasis);
            }
            if (tmpFile != null) {
                return tmpXDirectory;
            }
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return null;
    }

    /**
     * 
     * @param inpRecOnly true = search the .rec-dirs only
     * @return XInputDirectory[]
     */
    public XInputDirectory[] getFmpgDirectories(boolean inpRecOnly) {
        XInputDirectory[] tmpDirectories = null;
        try {
            int anzf = (dateiNamenBasen == null) ? 0 : dateiNamenBasen.length;
            for (int i = 0; i < anzf; i++) {
                String tmpDateinamenbasis = dateiNamenBasen[i];
                XInputDirectory tmpDirectory = getFmpgDirectory(tmpDateinamenbasis, inpRecOnly);
                if (tmpDirectories == null) {
                    tmpDirectories = new XInputDirectory[anzf];
                }
                tmpDirectories[i] = tmpDirectory;
            } // for i
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return tmpDirectories;
    }

    protected XInputFile getCridFile() {
        return aCridFile;
    }

    protected void setCridFile(XInputFile inpCridFile) {
        aCridFile = inpCridFile;
    }

} // Ende von class GAufnahme
